#! /bin/sh
#
#   kon2alt.sh -- start kon2 on another VTY session
#	0.0: Aug.  7, 2015 (v1.5)
#	0.1: Nov. 23, 2016 (v1.6)
#

PATH=/usr.bin:/usr/bin:/bin:/usr.sbin:/usr/sbin:/sbin:/usr/local/bin:/wipeout:.
export PATH

export TERM=vt100
export TTY=`/usr.bin/tty`

export TTY="${TTY:-ttyv0}"
export LOGFIL="${LOGFIL:-/tmp/wpoutlog.txt}"

n=`echo "$TTY" | sed 's/^.*\([0-9]\)/\1/'`
n=$(( $n + 1 ))
m=$(( $n + 1 ))
ntty=`echo $TTY | sed 's/[0-9]$/'"$n"'/'`

case x"$n" in
    x[0-6])
	echo ''
	echo "Starting new console session on VTY$n (Alt+F$m)"
	/wipeout/shell-on $ntty
	echo -n 'You can start yet another wipe-out session with '> $ntty
	echo '"sh /wipeout/kon2alt.sh"' > $ntty
	echo -n "Starting console session on VTY$n" >> $LOGFIL
	date >> $LOGFIL
	;;
esac
sleep 2

# 2016-12-07
KON2MODE='default'
if [ -f /tmp/kon2mode.txt ]; then
	KON2MODE=`sed -n 1p /tmp/kon2mode.txt`
fi
export KON2MODE

case x"$KON2MODE" in
	xF*)
		/usr/local/bin/kon2fixed FIX -s -e /wipeout/alt-menu.sh < $TTY
		;;
	*)
		/usr/local/bin/kon -s -e /wipeout/alt-menu.sh < $TTY
		;;
esac

# EOF
