#! /bin/sh
#
#   mainmenu.sh -- ϡɥǥõġᥤ (floppy)
#
#	0.0: Oct. 30, 2001 by Dai ISHIJIMA (as startup.sh)
#	0.1: Oct. 22, 2002 (for v01)
#	0.2: May   1, 2004 (for v02)
#	0.3: Jun. 19, 2004 (for v03, as mainmenu.sh)
#	0.4: Jul. 11, 2004 (for v04)
#	0.5: Jul.  9, 2005 (for v06)
#	0.6: Feb. 17, 2005 (for v08)
#	0.7: May  17, 2020 (for v20)
#

export EPOCH="${EPOCH:-1589760000}" # Mon May 18 09:00:00 JST 2020
export SID="${SID:-ABCD:EFGH}"
ttyname=`tty | sed 's+/dev/++' | sed 's|/|.|'`

dmesg="${DMESG:-/var/run/dmesg.boot}"
devices="${DEVICES:-ada|da}"

resultfil=/tmp/result
sed -n -E "/^(${devices})[0-9][0-9]*:.*B [<(]/p" $dmesg |
	sed 's/^\([a-z][a-z]*[0-9][0-9]*\).*/\1/' > $resultfil

disks=`sed -n '1p' $resultfil`

set $disks
disk=$1
stuffs='10'
dumpskip=0

while true ; do
	dname=`sed -n -E "/^${disk}:.*<.*>/p" $dmesg | sed 's/.*\(<.*>\).*/\1/'`
	bytes=`disksize -B /dev/$disk`
	cap=`disksize -p /dev/$disk`

	echo '*** Hard Disk wiping tool "wipe-out" ***' "($ttyname)"
	echo ''
	echo "current disk: /dev/${disk} ${dname}"
	echo "    capacity: $bytes bytes ($cap)"
	echo ''
	echo '    0: write "0" onto the disk'
	echo '    1: write "1" onto the disk'
	echo '    2: erase data with multiple writing'
	echo '    3: select multi-write method'
	echo '    4: verify disk (quick)'
	echo '    5: verify disk (normal)'
	echo '    6: write erase log onto the disk'
	echo '    7: select disk'
	echo '    8: dump sector'
	echo '    9: set sector number to dump'
	echo '    a: write random data onto the disk'
	echo '    b: run shell (sh)'
	echo '    c: reboot'
	echo '    d: shutdown'
	echo '    e: show SMART'
	echo '    f: secure erase'
	echo ''
	echo -n 'enter number [0-9a-f]: '
	read ans

	case x"${ans}" in
		x0)
			sh erase.sh -z $disk
			;;
		x1)
			sh erase.sh -f $disk
			;;
		x2)
			sh fine-erase.sh $stuffs $disk
			;;
		x3)
			. sel-fine.sh
			;;
		x4)
			sh verify.sh 90 $disk
			;;
		x5)
			sh verify.sh 0 $disk
			;;
		x6)
			sh writelog.sh $disk
			;;
		x7)
			. seldisk.sh
			;;
		x8)
			echo ''
			echo "*** sector $dumpskip of disk $disk"
			dd if=/dev/$disk skip=$dumpskip count=1 2>/dev/null | tinydump
			dumpskip=$(( $dumpskip + 1 ))
			echo -n "Press ENTER to return menu"
			read enterkey
			;;
		x9)
			echo ''
			echo -n "***Enter sector number [$dumpskip] :"
			read sector
			echo "$sector" > /tmp/sector
			echo "$dumpskip" >> /tmp/sector
			dumpskip=`sed -n '/^[0-9]/p' /tmp/sector | sed -n 1p`
			;;
		xa)
			sh erase.sh -r $disk
			;;
		xb)
			/bin/sh -i
			;;
		xc)
			(sleep 10; /sbin/shutdown -r now) > /dev/null 2>&1 & 
			/sbin/shutdown -r now
			;;
		xd)
			(sleep 10; /sbin/shutdown -p now) > /dev/null 2>&1 & 
			/sbin/shutdown -p now
			;;
		xe)
			/usr/local/sbin/smartctl -s on /dev/$disk 2>&1
			/usr/local/sbin/smartctl -a /dev/$disk 2>&1
			sleep 2
			echo -n 'Press ENTER to return menu...'
			read x
			;;
		xf)
			sh atasecurity.sh $disk -e
			;;
	esac
	echo ''
	echo ''
done

exit 0

# EOF
