#! /bin/sh
#
#   floppylog.sh -- フロッピーにログを記録する
#
#	使い方: /bin/sh floppylog.sh [ディスク]
#		ディスク: デバイスファイルで指定、先頭の「/dev/」は省く
#		例: /bin/sh floppylog.sh fd0
#
#	0.0: Feb. 10, 2007 by Dai ISHIJIMA (for wpout08)
#	0.1: Feb. 15, 2007 (ディスクを選択する)
#	0.2: Feb. 15, 2007 (dmesg -a を最後に)
#	0.3: Feb. 18, 2007 (キャンセル失敗bugfix)
#	0.4: Feb. 20, 2007 (シェル変数も)
#	0.5: Feb. 21, 2007 (作業内容を最下行に表示)
#	0.6: Feb. 23, 2007 (改良: 作業内容を最下行に表示)
#	0.7: Sep. 12, 2007 (wpout09)
#	0.8: Oct.  6, 2007 (expr の代わりに $(( )) )
#	0.9: Mar. 22, 2014 (エラーログ)
#	1.0: Aug.  3, 2018 (操作履歴)
#	1.1: May. 21, 2020 for でループ, v2.0
#	1.2: Aug. 12, 2025 (wpout25, 14.2R, ja_JP.UTF-8)
#	1.3: Nov. 26, 2025 (wpout25, filename)
#

dmesg="${DMESG:-/var/run/dmesg.boot}"
ERRORLOG="${ERRORLOG:-/tmp/wperrlog.txt}"
disk="${1:-fd0}"
resultfil=/tmp/result

header=/tmp/header.txt
#cd /tmp
devfil=/tmp/devices.txt

title="${TITLE:-ハードディスク消去ツール『wipe-out』}"

dialog	--title "$TITLE" \
	--infobox "ログの保存先を検索しています" 3 64

/bin/sh logdev.sh > $devfil
if [ ! -s $devfil ]; then
	echo "no device to write log" >> $LOGFIL
	msg="ログの保存先がみつかりませんでした"
	sh dummyread.sh
	dialog --title "$title" --msgbox "$msg" 5 64
	exit 1
fi

devs=`cat $devfil`
ndevs=0
for d in $devs ; do
	ndevs=$(( $ndevs + 1 ))
done

case x"$ndevs" in
	x0)
		echo "no device to write log" >> $LOGFIL
		msg="ログの保存先がみつかりませんでした"
		sh dummyread.sh
		dialog --title "$title" --msgbox "$msg" 5 64
		exit 1
		;;
esac

taglist=''
for dev in $devs ; do
	d=`echo $dev | sed 's/^\([a-z][a-z]*[0-9]\).*/\1/'`
	dname=`sed -n -E "/^${d}:.*<.*>/p" $dmesg | sed 's/.*\(<.*>\).*/\1/'`
	taglist="$taglist $dev '$dname'"
done

sh dummyread.sh
eval dialog \
	--title "'$title'" \
	--menu "'ログの保存先を選択してください'" \
	10 72 3 \
	$taglist \
	2>$resultfil

case "$?" in
	0)
		disk=`cat $resultfil`
		msg="ログを ${disk} に保存します"
		dialog	--title "$title" --infobox "$msg" 3 64
		;;
	1)
		dialog	--title "$title" \
			--infobox 'ログの保存をキャンセルしました' 3 64
		sleep 2
		# 2007-02-18
		exit 1
		;;
esac

echo -e "\r                                        \r\c"
echo -n "mounting floppy"
if ! mount_msdosfs /dev/$disk /floppy > /dev/null 2>&1; then
	msg="保存先 ${disk} を書き込みマウントできませんでした"
	dialog --title "$title" --msgbox "$msg" 5 64
	exit 1
fi

# 消去ログ
cp /dev/null /tmp/eraselog.txt
for i in /tmp/erase-log.* ; do
	if [ -s $i ]; then
		cat $i >> /tmp/eraselog.txt
	fi
done
if [ ! -s /tmp/eraselog.txt ]; then
	echo 'No erase log found' >> /tmp/eraselog.txt
fi

# 確認ログ
cp /dev/null /tmp/verfylog.txt
for i in /tmp/verify-log.* ; do
	if [ -s $i ]; then
		cat $i >> /tmp/verfylog.txt
	fi
done
if [ ! -s /tmp/verfylog.txt ]; then
	echo 'No verify log found' >> /tmp/verfylog.txt
fi

# シェル変数
set > /tmp/environ.txt

#
cp /var/run/dmesg.boot /tmp/dmsgboot.txt

# dmesg-a
dmesg -a > /tmp/dmesg-a.txt


echo "" > $header
echo -n "####################################" >> $header
echo	"####################################" >> $header
echo -n "following messages were logged on " >> $header
date >> $header
echo -n "====================================" >> $header
echo	"====================================" >> $header

cd /tmp
logs="dmsgboot.txt mm-error.txt wpoutlog.txt mbrlog.txt"
logs="${logs} wperrlog.txt history.txt"
logs="${logs} eraselog.txt verfylog.txt environ.txt dmesg-a.txt"
logs="${logs} fd-mode.txt"
logs="${logs} [0-9]*[0-9].txt"


for log in $logs ; do
    if [ -s $log ]; then
	echo -e "\r                                        \r\c"
	echo -n "writing $log header"
	if ! nkf -sc < $header >> /floppy/wipe-out/$log ; then
		umount /floppy
		msg="${log} ヘッダの書き込みに失敗しました"
		dialog --title "$title" --msgbox "$msg" 5 64
		exit 1
	fi
	echo -e "\r                                        \r\c"
	echo -n "writing $log body"
	if ! nkf -sc < $log >> /floppy/wipe-out/$log ; then
		umount /floppy
		msg="${log} 本体の書き込みに失敗しました"
		dialog --title "$title" --msgbox "$msg" 5 64
		exit 1
	fi
    fi
done

umount /floppy

dialog	--title "$title" \
	--msgbox "ログの書き込みが終了しました" 5 64


exit 0

# EOF
